/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef AGTPORTSELECTOR_H
#define AGTPORTSELECTOR_H

#include "AgtPCIPort.h"

class CAgtPCIEControl;

// Provides basic access functionality to the PCIE driver.
/** Allows to open and close the connection to a probe board via the PCIE driver.
An instance of this class must be created and ConnectPort() called, before
any Exerciser function can be executed sucessfully.
*/
class AGTPCIPORT_API CAgtPortSelector
{
  /* 
  - Contains functions for opening and closing the connection to PCI driver,
  which must be called to obtain a port handle.
  - Visible to customer
  - OS independent
  - Creates and holds instance of class CAgtPCIEControl.
  All functions of this class are directly mapped to class CAgtPCIEControl.
  */
public:
  CAgtPortSelector( void );
  ~CAgtPortSelector( void );

  /// Opens a connection to the specified probe board via the PCIE driver.
  /** Opens a connection to the specified probe board via the PCIE driver.
  Parameter devid consists of busnumber (bits 15-8), slotnumber (bits 7-3)
  and functionnumber (bits 2-0). Slotnumber and functionnumber must always be zero.
  Parameter devid can be obtained by calling DeviceIdGet() before.
  ConnectPort returns a port handle needed for following calls to exerciser functions.
  */
  void ConnectPort( UInt32 deviceId, AgtPortHandleT* porthandle );

  /// Returns the OS Handle 'osHandle' of the porthandle 'porthandle'.
  void OSHandleGet( AgtPortHandleT porthandle, HANDLE * osHandle );

  /// Closes a previously opened connection to the PCIE driver.
  /** Closes a previously opened connection to the PCIE driver.
  Must be passed the port handle previously returned from ConnectPort().
  */
  void DisconnectPort( AgtPortHandleT );

  /// Converts zero-based index into deviceId for calling ConnectPort() afterwards.
  /** Converts zero-based index, denoting the i'th found Probe board,
  into deviceId for calling ConnectPort() afterwards.
  */
  void DeviceIdGet( UInt16 index, UInt32* deviceId );

protected:
  void DeviceIdGet( UInt16 vendId, UInt16 devId, UInt16 index, UInt32* deviceId );
  CAgtPCIEControl* myController;
};

#endif